//: ## Protocols
//:
//: Protocols enforce that certain properties and functions exist.
//:
//: It's a contract.
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


protocol OperatingSystem {
    var name: String { get }
    var version: String { get }
}


//:
//: -------------------
//:
//: Protocols In Action
//:
//: -------------------
//:


struct MacOperatingSystem: OperatingSystem {
    let name: String
    let version: String
}

struct WindowsOperatingSystem: OperatingSystem {
    let name: String
    let version: String
}


//:
//: -------------------
//:
//: ## Instances
//:
//: -------------------
//:


let operatingSystem1: OperatingSystem = MacOperatingSystem(name: "Sonoma", version: "1.0")
let operatingSystem2: OperatingSystem = WindowsOperatingSystem(name: "Windows Ten", version: "10")


//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ## ![3 Days Of Swift Logo](3DaysIcon146.png) 3 Days Of Swift
//:
//: © Copyright. All rights reserved.
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
